CREATE OR REPLACE VIEW vit.values_without_verification AS
SELECT
    h.street,
    h.number AS house,
    m.manufacturer,
    m.model,
    m.serialnumber AS serial_number,
    mr.datetimeoffset AS date,
    mr.firsttariffvalue AS t1,
    mr.secondtariffvalue AS t2,
    mr.thirdtariffvalue AS t3
FROM vit.meter_read mr
JOIN vit.meter m ON m.id = mr.meter_id
    AND m.apartments_id IS NULL  
JOIN vit.house h ON h.id = m.house_id
WHERE NOT EXISTS (
    SELECT 1
    FROM vit.verification v
    WHERE v.meter_id = mr.meter_id
        AND mr.datetimeoffset BETWEEN v.verifiction_date AND v.validto
)

UNION ALL

SELECT
    h.street,
    h.number AS house,
    m.manufacturer,
    m.model,
    m.serialnumber AS serial_number,
    mr.datetimeoffset AS date,
    mr.firsttariffvalue AS t1,
    mr.secondtariffvalue AS t2,
    mr.thirdtariffvalue AS t3
FROM vit.meter_read mr
JOIN vit.meter m ON m.id = mr.meter_id
    AND m.apartments_id IS NOT NULL  
JOIN vit.apartments a ON a.id = m.apartments_id
JOIN vit.house h ON h.id = a.house_id
WHERE NOT EXISTS (
    SELECT 1
    FROM vit.verification v
    WHERE v.meter_id = mr.meter_id
        AND mr.datetimeoffset BETWEEN v.verifiction_date AND v.validto
)

ORDER BY 
    street, 
    house, 
    manufacturer, 
    model, 
    serial_number, 
    date;


Select * from vit.values_without_verification limit 1